/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpDecPipe.c,v 1.4 2001/01/25 22:11:50 jeffc Exp $
____________________________________________________________________________*/
/*
 * pgpDecPipe.c -- setup the Decryption Pipeline, given the arguments
 * of the UI.  This is just a helper function to setup the decryption
 * pipeline.  It would be just as easy for an application to do it.
 *
 * Written by:	Derek Atkins <warlord@MIT.EDU
 */

#include "pgpConfig.h"

#include <stdio.h>

#include "pgpDecPipe.h"
#include "pgpFIFO.h"
#include "pgpPrsAsc.h"
#include "pgpReadAnn.h"

PGPPipeline **
pgpDecryptPipelineCreate (
	PGPContextRef		cdkContext,
	PGPPipeline **		head,
	PGPEnv *			env,
	PGPFifoDesc const *	fd,
	PGPUICb const *		ui,
	void *				ui_arg)
{
	if (!head)
		return NULL;

	if (!fd)
		fd = &pgpByteFifoDesc;

	head = pgpParseAscCreate ( cdkContext, head, env, fd, ui, ui_arg);
	if (!head)
		return NULL;

	return pgpAnnotationReaderCreate ( cdkContext, head, env, ui, ui_arg);
}
